/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;
import jclass.bwt.JCTextField;
import jclass.bwt.Shadow;
import jclass.bwt.SpinBoxConverter;
import jclass.util.JCVector;

public class JCSpinBox
extends JCContainer
implements KeyListener,
JCActionListener {
    JCTextField text;
    JCArrowButton decr_arrow;
    JCArrowButton incr_arrow;
    int position;
    int min;
    int max = Integer.MAX_VALUE;
    int incr = 1;
    int decimals;
    Object value;
    boolean auto_arrow_disable = true;
    protected int shadow = 2;
    protected static final int NONE = 0;
    protected static final int INCREMENT = 1;
    protected static final int DECREMENT = -1;
    static final int BEGIN = 0;
    static final int END = 1;
    private int pow = (int)Math.pow(10.0, this.decimals);
    private char decimal_point_char;
    protected JCVector listeners = new JCVector(0);
    private static final String base = "spinbox";
    private static int nameCounter;

    public JCSpinBox() {
        this(null, null);
    }

    public JCSpinBox(int n) {
        this(null, null);
        this.text.setColumns(n);
    }

    public JCSpinBox(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        if (this.getClass().getName().equals("jclass.bwt.JCSpinBox")) {
            this.getParameters(applet);
        }
        this.setLayout(null);
        this.text = new JCTextField();
        this.add(this.text);
        this.incr_arrow = new JCArrowButton(10);
        this.add(this.incr_arrow);
        this.decr_arrow = new JCArrowButton(9);
        this.add(this.decr_arrow);
        this.decr_arrow.initial_delay = 250;
        this.incr_arrow.initial_delay = 250;
        this.text.addActionListener(this);
        this.decr_arrow.traversable = false;
        this.incr_arrow.traversable = false;
        this.text.addKeyListener(this);
        this.text.shadow = 0;
        this.incr_arrow.addActionListener(this);
        this.decr_arrow.addActionListener(this);
        this.initTextValue();
    }

    protected void getParameters() {
        super.getParameters();
        SpinBoxConverter.getParams(this);
    }

    public JCTextField getTextField() {
        return this.text;
    }

    public JCArrowButton getDecrementArrow() {
        return this.decr_arrow;
    }

    public JCArrowButton getIncrementArrow() {
        return this.incr_arrow;
    }

    public boolean getAutoArrowDisable() {
        return this.auto_arrow_disable;
    }

    public void setAutoArrowDisable(boolean bl) {
        this.auto_arrow_disable = bl;
        this.enableArrowButtons();
    }

    public int getDecimalPlaces() {
        return this.decimals;
    }

    public void setDecimalPlaces(int n) {
        this.decimals = n;
        this.pow = (int)Math.pow(10.0, n);
        this.setTextValue(this.value);
    }

    public int getIncrement() {
        return this.incr;
    }

    public void setIncrement(int n) {
        this.incr = n;
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
        this.validate(this.value);
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
        this.validate(this.value);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
        this.value = new Integer((this.position - this.min) / this.incr + this.min);
        this.setTextValue(this.value);
        this.enableArrowButtons();
    }

    public int getIntValue() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return Integer.parseInt(this.text.getText());
    }

    public void setIntValue(int n) {
        this.value = new Integer(n);
        this.setTextValue(this.value);
        this.enableArrowButtons();
    }

    public String getValue() {
        return this.text.getText();
    }

    public synchronized void setText(String string) {
        if (string == null || string.length() == 0) {
            this.setIntValue(this.min);
            return;
        }
        this.setTextValue(string);
        this.enableArrowButtons();
    }

    public synchronized String getText() {
        return this.text.getText();
    }

    public void addSpinBoxListener(JCSpinBoxListener jCSpinBoxListener) {
        this.listeners.add(jCSpinBoxListener);
    }

    public void removeSpinBoxListener(JCSpinBoxListener jCSpinBoxListener) {
        this.listeners.removeElement(jCSpinBoxListener);
    }

    protected int preferredWidth() {
        return this.text.preferredSize().width + this.incr_arrow.preferredSize().width + 2 * this.shadow;
    }

    protected int preferredHeight() {
        return 2 * this.shadow + this.text.preferredSize().height;
    }

    public synchronized void layout() {
        int n = this.incr_arrow.preferredSize().width;
        int n2 = this.text.preferredSize().height / 2;
        int n3 = this.size().width - n - this.shadow;
        this.text.reshape(this.shadow, this.shadow, this.size().width - n - 2 * this.shadow, n2 * 2);
        this.incr_arrow.reshape(n3, this.shadow, n, n2);
        this.decr_arrow.reshape(n3, n2 + this.shadow, n, n2);
        this.enableArrowButtons();
    }

    public void paintInterior(Graphics graphics) {
        graphics.clearRect(0, 0, this.size().width, this.size().height);
        Shadow.draw(graphics, 3, this.shadow, 0, 0, this.size().width, this.size().height, this.getBackground(), this.getForeground());
    }

    protected JCSpinBoxEvent postSpinBoxEvent(int n, Object object) {
        if (this.listeners.size() == 0) {
            return null;
        }
        JCSpinBoxEvent jCSpinBoxEvent = new JCSpinBoxEvent(this, this.position, object);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            JCSpinBoxListener jCSpinBoxListener = (JCSpinBoxListener)this.listeners.elementAt(n2);
            if (n == 0) {
                jCSpinBoxListener.spinBoxChangeBegin(jCSpinBoxEvent);
            } else {
                jCSpinBoxListener.spinBoxChangeEnd(jCSpinBoxEvent);
            }
            ++n2;
        }
        return jCSpinBoxEvent;
    }

    protected char getDecimalPointChar() {
        if (this.decimal_point_char != '\u0000') {
            return this.decimal_point_char;
        }
        this.decimal_point_char = new Double(5.5).toString().charAt(1);
        return this.decimal_point_char;
    }

    protected Object calcValue(int n) {
        int n2;
        int n3 = n == 0 ? 0 : (n2 = n == 1 ? this.incr : -this.incr);
        if (this.value == null) {
            this.value = new Integer(this.min);
        }
        int n4 = (Integer)this.value + n2;
        n4 = Math.max(Math.min(n4, this.max), this.min);
        this.position = (n4 - this.min) / this.incr;
        return new Integer(n4);
    }

    protected void initTextValue() {
        this.value = new Integer(this.min);
        this.position = 0;
        this.setTextValue(this.value);
    }

    protected void setTextValue(Object object) {
        String string;
        String string2 = string = object != null ? object.toString() : null;
        if (this.decimals > 0) {
            string = new Double(((Integer)object).doubleValue() / (double)this.pow).toString();
            int n = string.indexOf(this.getDecimalPointChar());
            if (n == -1) {
                string = String.valueOf(string) + this.getDecimalPointChar();
                n = string.length() - 1;
            }
            int n2 = string.length() - n - 1;
            while (n2 < this.decimals) {
                string = String.valueOf(string) + '0';
                ++n2;
            }
        }
        this.text.setText(string);
        this.postSpinBoxEvent(1, object);
    }

    public void setTextAction(int n) {
        if (this.text.getChanged() && !this.validate(this.text.getText())) {
            this.text.beep();
            return;
        }
        Object object = this.calcValue(n);
        JCSpinBoxEvent jCSpinBoxEvent = this.postSpinBoxEvent(0, object);
        if (jCSpinBoxEvent != null) {
            if (!jCSpinBoxEvent.doit) {
                return;
            }
            if (object != jCSpinBoxEvent.value && !this.validate(jCSpinBoxEvent.value)) {
                return;
            }
            object = jCSpinBoxEvent.value;
        }
        this.value = object;
        this.setTextValue(this.value);
        this.enableArrowButtons();
    }

    protected void enableArrowButtons() {
        if (!this.auto_arrow_disable) {
            this.incr_arrow.enable(true);
            this.decr_arrow.enable(true);
            return;
        }
        int n = (Integer)this.value;
        this.incr_arrow.enable(n < this.max);
        this.decr_arrow.enable(n > this.min);
    }

    protected boolean validate(Object object) {
        double d;
        boolean bl = false;
        char c = this.getDecimalPointChar();
        if (object instanceof String) {
            String string = (String)object;
            try {
                int n;
                if (this.decimals == 0) {
                    n = Integer.parseInt(string);
                } else {
                    if (string.indexOf(c) == 0) {
                        string = String.valueOf(string) + '.';
                    }
                    double d2 = Double.valueOf(string);
                    n = (int)Math.ceil(d2 * (double)this.pow);
                }
                if (bl = n >= this.min && n <= this.max) {
                    this.position = (n - this.min) / this.incr;
                    this.value = new Integer(n);
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            bl = n >= this.min && n <= this.max;
            if (bl) {
                this.position = (n - this.min) / this.incr;
            }
        } else if (object instanceof Number && (bl = (d = ((Double)object).doubleValue()) >= (double)this.min && d <= (double)this.max)) {
            this.position = ((int)d - this.min) / this.incr;
        }
        return bl;
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.incr_arrow) {
            this.setTextAction(1);
            return;
        }
        if (jCActionEvent.getSource() == this.decr_arrow) {
            this.setTextAction(-1);
            return;
        }
        if (jCActionEvent.getSource() == this.text && this.text.getEditable()) {
            this.setTextAction(0);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.setTextAction(1);
                return;
            }
            case 40: {
                this.setTextAction(-1);
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public final void setLayout(LayoutManager layoutManager) {
    }
}

